   /*  contest_vol_subclass.sas  -- 
code that sets level of contestability for program.  */

%macro GetContestabilityLevel(contest, skimfactor);

    %put Contestability Level:  &contest;
    %put Skim Factor:  &skimfactor;
      
  /*d3	First class presort
d5	First class presort cards
d10	Periodicals
d16	Standard Regular CR
d17 Standard Regular
d23	Parcel post*/


    %if &contest="1_base" %then %do;
            c_d3 = (&skimfactor * d3) * 0.2006248;           
            c_d5 = (&skimfactor * d5) * 0.2057015;
            c_d10 = (&skimfactor * d10) * 0.3347874;
            c_d16 = (&skimfactor * d16) * 0.8122580;
            c_d17 = (&skimfactor * d17) * 0.1931834;
            c_d23 = (&skimfactor * d23) * 0.5235580;
        %end;
	%else %if &contest="2_low" %then %do;
            c_d3 = (&skimfactor * d3) * 0.1003124;           
            c_d5 = (&skimfactor * d5) * 0.1028508;
            c_d10 = (&skimfactor * d10) * 0.1673937;
            c_d16 = (&skimfactor * d16) * 0.4061290;
            c_d17 = (&skimfactor * d17) * 0.0965917;
            c_d23 = (&skimfactor * d23) * 0.2617790;
        %end;
	 %else %if &contest="3_high" %then %do;
             c_d3 = (&skimfactor * d3) *  0.300937255;           
            c_d5 = (&skimfactor * d5) * 0.308552304;
            c_d10 = (&skimfactor * d10) * 0.502181088;
            c_d16 = (&skimfactor * d16) * 1;
            c_d17 = (&skimfactor * d17) * 0.289775112;
            c_d23 = (&skimfactor * d23) * 0.78533703;
        %end;
 	%else %if &contest="35percent" %then %do;
            c_d3 = (&skimfactor * d3) * 0.0702187;           
            c_d5 = (&skimfactor * d5) * 0.0719955;
            c_d10 = (&skimfactor * d10) * 0.1171756;
            c_d16 = (&skimfactor * d16) * 0.2842903;
            c_d17 = (&skimfactor * d17) * 0.0676142;
            c_d23 = (&skimfactor * d23) * 0.1832453;
        %end;
	%else %if &contest="70percent" %then %do;
            c_d3 = (&skimfactor * d3) * 0.1404374;           
            c_d5 = (&skimfactor * d5) * 0.1439911;
            c_d10 = (&skimfactor * d10) * 0.2343512;
            c_d16 = (&skimfactor * d16) * 0.5685806;
            c_d17 = (&skimfactor * d17) * 0.1352284;
            c_d23 = (&skimfactor * d23) * 0.3664906;
        %end;
%mend GetContestabilityLevel;
 
 
 
